


import numpy as np
import matplotlib
matplotlib.use('TkAgg')
import matplotlib.pyplot as plt
import torch
import sys

import argparse

from scipy.stats import norm


#
#sparsity_isi0_in12n64 =  [[[0.203125, 0.109375, 0.015625, 0.0625, 0.09375, 0.15625, 0.0, 0.1875, 0.1875, 0.015625, 0.09375, 0.296875], [0.123291015625, 0.082763671875, 0.070556640625, 0.0623779296875, 0.0755615234375, 0.1239013671875, 0.0595703125, 0.15869140625, 0.10595703125, 0.0740966796875, 0.0712890625, 0.113525390625]], [[0.359375, 0.109375, 0.015625, 0.078125, 0.109375, 0.15625, 0.0, 0.1875, 0.1875, 0.0625, 0.234375, 0.34375], [0.263916015625, 0.1707763671875, 0.142578125, 0.1387939453125, 0.16357421875, 0.2310791015625, 0.1102294921875, 0.28125, 0.2171630859375, 0.1513671875, 0.1439208984375, 0.2236328125]], [[0.390625, 0.109375, 0.09375, 0.078125, 0.109375, 0.15625, 0.0, 0.1875, 0.1875, 0.0625, 0.25, 0.4375], [0.381103515625, 0.25244140625, 0.2080078125, 0.2135009765625, 0.23583984375, 0.329345703125, 0.1602783203125, 0.380615234375, 0.306396484375, 0.2288818359375, 0.2147216796875, 0.3271484375]], [[0.390625, 0.109375, 0.109375, 0.078125, 0.109375, 0.15625, 0.0, 0.203125, 0.1875, 0.0625, 0.25, 0.4375], [0.486328125, 0.315673828125, 0.275634765625, 0.28125, 0.31591796875, 0.409912109375, 0.203125, 0.46728515625, 0.39208984375, 0.2991943359375, 0.2816162109375, 0.422607421875]], [[0.421875, 0.109375, 0.109375, 0.078125, 0.109375, 0.15625, 0.0, 0.203125, 0.1875, 0.0625, 0.28125, 0.4375], [0.590087890625, 0.3778076171875, 0.3331298828125, 0.3397216796875, 0.3773193359375, 0.49560546875, 0.25390625, 0.5452880859375, 0.4598388671875, 0.36328125, 0.3370361328125, 0.509521484375]], [[0.4375, 0.109375, 0.109375, 0.09375, 0.109375, 0.15625, 0.0, 0.21875, 0.1875, 0.0625, 0.28125, 0.4375], [0.672607421875, 0.4449462890625, 0.3939208984375, 0.3963623046875, 0.4349365234375, 0.5579833984375, 0.2928466796875, 0.6153564453125, 0.520263671875, 0.4228515625, 0.39404296875, 0.576171875]], [[0.4375, 0.109375, 0.109375, 0.09375, 0.109375, 0.15625, 0.0, 0.296875, 0.28125, 0.0625, 0.28125, 0.4375], [0.7236328125, 0.48974609375, 0.441650390625, 0.4501953125, 0.486328125, 0.617431640625, 0.376220703125, 0.6822509765625, 0.5704345703125, 0.46826171875, 0.437744140625, 0.625732421875]], [[0.4375, 0.109375, 0.109375, 0.09375, 0.109375, 0.15625, 0.0, 0.359375, 0.3125, 0.0625, 0.296875, 0.4375], [0.76953125, 0.5418701171875, 0.4998779296875, 0.5025634765625, 0.5386962890625, 0.666015625, 0.40673828125, 0.72607421875, 0.6094970703125, 0.5279541015625, 0.4888916015625, 0.681396484375]], [[0.4375, 0.125, 0.125, 0.09375, 0.109375, 0.15625, 0.0, 0.359375, 0.421875, 0.0625, 0.296875, 0.4375], [0.806640625, 0.5997314453125, 0.552734375, 0.5543212890625, 0.5909423828125, 0.7039794921875, 0.4375, 0.766357421875, 0.6505126953125, 0.5760498046875, 0.530517578125, 0.71533203125]], [[0.4375, 0.125, 0.15625, 0.09375, 0.15625, 0.15625, 0.0, 0.375, 0.421875, 0.0625, 0.296875, 0.4375], [0.834716796875, 0.646484375, 0.602294921875, 0.6005859375, 0.6343994140625, 0.7425537109375, 0.47314453125, 0.7955322265625, 0.6856689453125, 0.6187744140625, 0.56591796875, 0.751953125]]]
#ber_isi0_in12n64 = [0.001528, 0.001499, 0.001466, 0.001529, 0.001573, 0.002415, 0.002404, 0.002326, 0.00241, 0.002431]
#
#plt.figure('isi0_in12n64_row0', figsize=[4,12])
#for k in range(len(sparsity_isi0_in12n64)):
#	plt.subplot(len(sparsity_isi0_in12n64),1,k+1)
#	plt.title("ber:%e"%ber_isi0_in12n64[k])
#	plt.bar(range(len(sparsity_isi0_in12n64[k][0])),sparsity_isi0_in12n64[k][0])
#	plt.ylim([0,1.0])
#	plt.grid(True)
#plt.tight_layout()
#
#
#plt.figure('isi0_in12n64_row1', figsize=[4,12])
##plt.title('isi0_in12n64_row1')
#for k in range(len(sparsity_isi0_in12n64)):
#	plt.subplot(len(sparsity_isi0_in12n64),1,k+1)
#	plt.title("ber:%e"%ber_isi0_in12n64[k])
#	plt.bar(range(len(sparsity_isi0_in12n64[k][1])),sparsity_isi0_in12n64[k][1])
#	plt.ylim([0,1.0])
#	plt.grid(True)
#plt.tight_layout()
#
#
#sparsity_isi1_in12n64 =  [[[0.328125, 0.265625, 0.0625, 0.109375, 0.203125, 0.09375, 0.015625, 0.125, 0.34375, 0.03125, 0.15625, 0.390625], [0.1103515625, 0.1036376953125, 0.0618896484375, 0.0750732421875, 0.0809326171875, 0.0650634765625, 0.0469970703125, 0.0682373046875, 0.0670166015625, 0.0526123046875, 0.103515625, 0.348388671875]], [[0.40625, 0.296875, 0.109375, 0.171875, 0.28125, 0.140625, 0.015625, 0.125, 0.390625, 0.125, 0.1875, 0.953125], [0.22216796875, 0.212158203125, 0.1297607421875, 0.154296875, 0.1666259765625, 0.130615234375, 0.0902099609375, 0.1278076171875, 0.1495361328125, 0.111328125, 0.2086181640625, 0.752685546875]], [[0.40625, 0.296875, 0.171875, 0.1875, 0.28125, 0.140625, 0.015625, 0.125, 0.390625, 0.125, 0.1875, 0.984375], [0.330810546875, 0.3148193359375, 0.2049560546875, 0.23193359375, 0.2493896484375, 0.20166015625, 0.136474609375, 0.19287109375, 0.2252197265625, 0.169189453125, 0.328857421875, 0.9228515625]], [[0.40625, 0.3125, 0.171875, 0.203125, 0.296875, 0.140625, 0.015625, 0.125, 0.390625, 0.125, 0.1875, 0.984375], [0.44873046875, 0.4090576171875, 0.271728515625, 0.3134765625, 0.3255615234375, 0.2666015625, 0.17822265625, 0.259765625, 0.293701171875, 0.226806640625, 0.44091796875, 0.98974609375]], [[0.40625, 0.3125, 0.171875, 0.203125, 0.3125, 0.140625, 0.015625, 0.140625, 0.390625, 0.125, 0.1875, 0.984375], [0.556396484375, 0.491455078125, 0.3369140625, 0.3851318359375, 0.401611328125, 0.3323974609375, 0.2164306640625, 0.327880859375, 0.350341796875, 0.2811279296875, 0.5447998046875, 0.99951171875]], [[0.40625, 0.3125, 0.171875, 0.21875, 0.328125, 0.140625, 0.015625, 0.140625, 0.421875, 0.125, 0.1875, 0.984375], [0.651123046875, 0.5726318359375, 0.39453125, 0.458251953125, 0.464599609375, 0.390625, 0.25390625, 0.389404296875, 0.4056396484375, 0.3282470703125, 0.6292724609375, 0.999755859375]], [[0.40625, 0.3125, 0.171875, 0.25, 0.34375, 0.140625, 0.015625, 0.140625, 0.421875, 0.125, 0.203125, 0.984375], [0.7177734375, 0.6278076171875, 0.4442138671875, 0.522705078125, 0.5228271484375, 0.448486328125, 0.298095703125, 0.456787109375, 0.4603271484375, 0.37548828125, 0.6912841796875, 0.999755859375]], [[0.421875, 0.3125, 0.171875, 0.265625, 0.34375, 0.15625, 0.015625, 0.140625, 0.421875, 0.125, 0.203125, 0.984375], [0.76611328125, 0.6734619140625, 0.49560546875, 0.5787353515625, 0.5762939453125, 0.5023193359375, 0.344482421875, 0.5223388671875, 0.5167236328125, 0.4176025390625, 0.7359619140625, 0.999755859375]], [[0.421875, 0.328125, 0.171875, 0.28125, 0.359375, 0.171875, 0.015625, 0.140625, 0.421875, 0.125, 0.234375, 0.984375], [0.790283203125, 0.71240234375, 0.5489501953125, 0.6292724609375, 0.6295166015625, 0.54736328125, 0.3907470703125, 0.5853271484375, 0.5687255859375, 0.457275390625, 0.7633056640625, 0.999755859375]], [[0.421875, 0.328125, 0.1875, 0.28125, 0.359375, 0.171875, 0.015625, 0.140625, 0.453125, 0.125, 0.234375, 0.984375], [0.8095703125, 0.7371826171875, 0.59033203125, 0.670654296875, 0.666015625, 0.596923828125, 0.4619140625, 0.651123046875, 0.61083984375, 0.4908447265625, 0.776611328125, 0.999755859375]]]
#
#ber_isi1_in12n64=[0.002476, 0.002486, 0.002499, 0.002469, 0.002443, 0.00247, 0.002528, 0.002696, 0.003422, 0.003412]
#
#
#plt.figure('isi1_in12n64_row0', figsize=[4,12])
##plt.title('isi1_in12n64_row0')
#for k in range(len(sparsity_isi1_in12n64)):
#	plt.subplot(len(sparsity_isi1_in12n64),1,k+1)
#	plt.title("ber:%e "%ber_isi1_in12n64[k])
#	plt.bar(range(len(sparsity_isi1_in12n64[k][0])),sparsity_isi1_in12n64[k][0])
#	plt.ylim([0,1.0])
#	plt.grid(True)
#plt.tight_layout()
#
#
#plt.figure('isi1_in12n64_row1', figsize=[4,12])
##plt.title('isi1_in12n64_row1')
#for k in range(len(sparsity_isi1_in12n64)):
#	plt.subplot(len(sparsity_isi1_in12n64),1,k+1)
#	plt.title("ber:%e "%ber_isi1_in12n64[k])
#	plt.bar(range(len(sparsity_isi1_in12n64[k][1])),sparsity_isi1_in12n64[k][1])
#	plt.ylim([0,1.0])
#	plt.grid(True)
#plt.tight_layout()
#
#

#sparsity_isi0_in12n32x32 =  [[[0.25, 0.125, 0.03125, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.09375, 0.1875], [0.3505859375, 0.1279296875, 0.16845703125, 0.1943359375, 0.1552734375, 0.20458984375, 0.09375, 0.1953125, 0.10400390625, 0.20166015625, 0.33837890625, 0.2802734375]], [[0.375, 0.125, 0.03125, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.25], [0.6904296875, 0.26416015625, 0.36279296875, 0.39453125, 0.30517578125, 0.365234375, 0.15869140625, 0.38037109375, 0.205078125, 0.3935546875, 0.67724609375, 0.5009765625]], [[0.375, 0.125, 0.03125, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.40625], [0.994140625, 0.3857421875, 0.52734375, 0.5654296875, 0.44384765625, 0.513671875, 0.22705078125, 0.54248046875, 0.30224609375, 0.57177734375, 0.96044921875, 0.734375]], [[0.375, 0.15625, 0.03125, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.40625], [1.2451171875, 0.4892578125, 0.69580078125, 0.7138671875, 0.572265625, 0.66748046875, 0.306640625, 0.68408203125, 0.3935546875, 0.70703125, 1.1689453125, 0.95703125]], [[0.375, 0.15625, 0.03125, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.53125], [1.4384765625, 0.58349609375, 0.822265625, 0.85986328125, 0.69384765625, 0.79638671875, 0.3818359375, 0.81982421875, 0.48193359375, 0.8330078125, 1.3271484375, 1.2099609375]], [[0.375, 0.15625, 0.03125, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.53125], [1.5654296875, 0.69384765625, 0.95654296875, 1.0078125, 0.8134765625, 0.9228515625, 0.4814453125, 0.93701171875, 0.568359375, 0.9384765625, 1.43896484375, 1.4033203125]], [[0.375, 0.15625, 0.03125, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.5625], [1.669921875, 0.81201171875, 1.0546875, 1.1337890625, 0.94677734375, 1.02734375, 0.57080078125, 1.04248046875, 0.68798828125, 1.046875, 1.5224609375, 1.515625]], [[0.375, 0.15625, 0.03125, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.5625], [1.7333984375, 0.919921875, 1.16552734375, 1.23095703125, 1.0673828125, 1.13720703125, 0.65673828125, 1.154296875, 0.783203125, 1.13623046875, 1.61767578125, 1.59375]], [[0.40625, 0.15625, 0.0625, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.5625], [1.7822265625, 1.0380859375, 1.26220703125, 1.31591796875, 1.18505859375, 1.24755859375, 0.73876953125, 1.2353515625, 0.88623046875, 1.2158203125, 1.68017578125, 1.66015625]], [[0.40625, 0.15625, 0.0625, 0.125, 0.09375, 0.09375, 0.03125, 0.0, 0.15625, 0.125, 0.21875, 0.5625], [1.80859375, 1.1435546875, 1.36181640625, 1.38916015625, 1.27783203125, 1.33544921875, 0.83642578125, 1.310546875, 0.96923828125, 1.3017578125, 1.7236328125, 1.7265625]]]
#sparsity_isi0_in12n32x32=(np.array(sparsity_isi0_in12n32x32)/2).tolist()
#ber_isi0_in12n32x32=[0.00171, 0.00176, 0.001681, 0.001638, 0.001674, 0.001686, 0.00166, 0.001732, 0.00171, 0.001706]
#plt.figure('isi0_in12n32x32_row0', figsize=[4,12])
##plt.title('isi0_in12n32x32_row0')
#for k in range(len(sparsity_isi0_in12n32x32)):
#	plt.subplot(len(sparsity_isi0_in12n32x32),1,k+1)
#	plt.title("ber:%e "%ber_isi0_in12n32x32[k])
#	plt.bar(range(len(sparsity_isi0_in12n32x32[k][0])),sparsity_isi0_in12n32x32[k][0])
#	plt.ylim([0,1.0])
#	plt.grid(True)
#plt.tight_layout()
#
#
#plt.figure('isi0_in12n32x32_row1', figsize=[4,12])
##plt.title('isi0_in12n32x32_row1')
#for k in range(len(sparsity_isi0_in12n32x32)):
#	plt.subplot(len(sparsity_isi0_in12n32x32),1,k+1)
#	plt.title("ber:%e "%ber_isi0_in12n32x32[k])
#	plt.bar(range(len(sparsity_isi0_in12n32x32[k][1])),sparsity_isi0_in12n32x32[k][1])
#	plt.ylim([0,1.0])
#	plt.grid(True)
#plt.tight_layout()
#
#
#sparsity_isi1_in12n32x32 =   [[[0.03125, 0.28125, 0.125, 0.09375, 0.125, 0.0, 0.0, 0.0625, 0.15625, 0.0625, 0.09375, 0.8125], [0.263671875, 0.24169921875, 0.099609375, 0.17333984375, 0.0927734375, 0.13818359375, 0.037109375, 0.1044921875, 0.1025390625, 0.07080078125, 0.205078125, 0.791015625]], [[0.25, 0.28125, 0.21875, 0.09375, 0.125, 0.0, 0.0, 0.0625, 0.40625, 0.1875, 0.21875, 0.8125], [0.5849609375, 0.52294921875, 0.21142578125, 0.36328125, 0.19580078125, 0.27197265625, 0.07666015625, 0.2373046875, 0.20703125, 0.13720703125, 0.46875, 1.337890625]], [[0.25, 0.28125, 0.21875, 0.09375, 0.125, 0.0, 0.0, 0.0625, 0.40625, 0.1875, 0.21875, 0.8125], [0.865234375, 0.76513671875, 0.3359375, 0.53662109375, 0.3076171875, 0.41748046875, 0.12890625, 0.3876953125, 0.3095703125, 0.2119140625, 0.69140625, 1.6884765625]], [[0.28125, 0.28125, 0.21875, 0.09375, 0.125, 0.0, 0.0, 0.0625, 0.40625, 0.1875, 0.21875, 0.875], [1.0986328125, 0.9287109375, 0.45751953125, 0.70556640625, 0.4541015625, 0.55712890625, 0.2041015625, 0.533203125, 0.43017578125, 0.29150390625, 0.91162109375, 1.83984375]], [[0.28125, 0.28125, 0.21875, 0.125, 0.125, 0.0, 0.0, 0.0625, 0.40625, 0.1875, 0.25, 0.875], [1.3056640625, 1.07568359375, 0.59619140625, 0.86865234375, 0.59033203125, 0.70068359375, 0.27880859375, 0.677734375, 0.5322265625, 0.3740234375, 1.083984375, 1.912109375]], [[0.28125, 0.28125, 0.21875, 0.125, 0.15625, 0.0, 0.0, 0.0625, 0.40625, 0.1875, 0.25, 0.875], [1.4482421875, 1.1953125, 0.72607421875, 1.017578125, 0.74072265625, 0.83349609375, 0.36669921875, 0.81689453125, 0.6318359375, 0.46826171875, 1.216796875, 1.9453125]], [[0.28125, 0.28125, 0.21875, 0.125, 0.15625, 0.0, 0.0, 0.0625, 0.40625, 0.1875, 0.25, 0.875], [1.5673828125, 1.29345703125, 0.85888671875, 1.154296875, 0.88720703125, 0.96337890625, 0.44873046875, 0.94970703125, 0.73876953125, 0.54833984375, 1.31103515625, 1.9716796875]], [[0.28125, 0.28125, 0.21875, 0.125, 0.15625, 0.0, 0.0, 0.0625, 0.40625, 0.1875, 0.25, 0.875], [1.6650390625, 1.384765625, 0.98193359375, 1.265625, 1.0166015625, 1.091796875, 0.54443359375, 1.04638671875, 0.84033203125, 0.64013671875, 1.390625, 1.9853515625]], [[0.28125, 0.28125, 0.21875, 0.125, 0.21875, 0.0, 0.0, 0.0625, 0.4375, 0.1875, 0.25, 0.875], [1.71875, 1.4716796875, 1.115234375, 1.3603515625, 1.142578125, 1.208984375, 0.63232421875, 1.1748046875, 0.93310546875, 0.744140625, 1.44970703125, 1.9892578125]], [[0.3125, 0.3125, 0.21875, 0.125, 0.21875, 0.0, 0.0, 0.0625, 0.4375, 0.1875, 0.25, 0.90625], [1.7587890625, 1.53662109375, 1.22314453125, 1.4521484375, 1.26708984375, 1.30712890625, 0.71923828125, 1.26806640625, 1.02783203125, 0.83642578125, 1.505859375, 1.9951171875]]]
#ber_isi1_in12n32x32=[0.002777, 0.0027, 0.002722, 0.002678, 0.00268, 0.002646, 0.002621, 0.00268, 0.002701, 0.002797]
#sparsity_isi1_in12n32x32=(np.array(sparsity_isi1_in12n32x32)/2).tolist()
#plt.figure('isi1_in12n32x32_row0', figsize=[4,12])
##plt.title('isi1_in12n32x32_row0')
#for k in range(len(sparsity_isi1_in12n32x32)):
#	plt.subplot(len(sparsity_isi1_in12n32x32),1,k+1)
#	plt.title("ber:%e "%ber_isi1_in12n32x32[k])
#	plt.bar(range(len(sparsity_isi1_in12n32x32[k][0])),sparsity_isi1_in12n32x32[k][0])
#	plt.ylim([0,1.0])
#	plt.grid(True)
#plt.tight_layout()
#
#
#plt.figure('isi1_in12n32x32_row1', figsize=[4,12])
##plt.title('isi1_in12n32x32_row1')
#for k in range(len(sparsity_isi1_in12n32x32)):
#	plt.subplot(len(sparsity_isi1_in12n32x32),1,k+1)
#	plt.title("ber:%e "%ber_isi1_in12n32x32[k])
#	plt.bar(range(len(sparsity_isi1_in12n32x32[k][1])),sparsity_isi1_in12n32x32[k][1])
#	plt.ylim([0,1.0])
#	plt.grid(True)
#plt.tight_layout()



sparsity_isi12dB = [[[0.03125, 0.03125, 0.125, 0.3125, 0.03125, 0.15625, 0.28125, 0.78125, 0.375, 0.1875, 0.125, 0.4375], [0.12841796875, 0.07291666666666667, 0.06640625, 0.040690104166666664, 0.043294270833333336, 0.0517578125, 0.06803385416666667, 0.1298828125, 0.0927734375, 0.0673828125, 0.20149739583333334, 0.28955078125]], [[0.125, 0.0625, 0.25, 0.3125, 0.40625, 0.1875, 0.375, 0.78125, 0.375, 0.1875, 0.125, 0.4375], [0.27490234375, 0.17643229166666666, 0.140625, 0.09407552083333333, 0.0986328125, 0.12109375, 0.1611328125, 0.2626953125, 0.16276041666666666, 0.11067708333333333, 0.3076171875, 0.47412109375]], [[0.40625, 0.125, 0.3125, 0.34375, 0.4375, 0.1875, 0.40625, 0.78125, 0.375, 0.1875, 0.125, 0.4375], [0.4189453125, 0.2955729166666667, 0.23046875, 0.1640625, 0.17610677083333334, 0.19563802083333334, 0.24446614583333334, 0.326171875, 0.21647135416666666, 0.1533203125, 0.37109375, 0.6083984375]], [[0.625, 0.125, 0.3125, 0.34375, 0.46875, 0.1875, 0.40625, 0.78125, 0.375, 0.1875, 0.125, 0.4375], [0.587890625, 0.4020182291666667, 0.3115234375, 0.22330729166666666, 0.2509765625, 0.267578125, 0.3291015625, 0.3707682291666667, 0.2561848958333333, 0.19954427083333334, 0.4296875, 0.6904296875]], [[0.625, 0.125, 0.3125, 0.34375, 0.46875, 0.1875, 0.40625, 0.78125, 0.375, 0.1875, 0.15625, 0.4375], [0.73046875, 0.5003255208333334, 0.3916015625, 0.2815755208333333, 0.3199869791666667, 0.3274739583333333, 0.4039713541666667, 0.4108072916666667, 0.30078125, 0.24674479166666666, 0.4798177083333333, 0.7373046875]], [[0.6875, 0.125, 0.3125, 0.34375, 0.46875, 0.1875, 0.40625, 0.78125, 0.375, 0.1875, 0.15625, 0.4375], [0.814453125, 0.5944010416666666, 0.45703125, 0.333984375, 0.3824869791666667, 0.3863932291666667, 0.466796875, 0.4537760416666667, 0.3388671875, 0.2972005208333333, 0.5348307291666666, 0.7822265625]], [[0.71875, 0.125, 0.3125, 0.34375, 0.46875, 0.1875, 0.40625, 0.78125, 0.40625, 0.1875, 0.15625, 0.4375], [0.8740234375, 0.6796875, 0.5169270833333334, 0.3902994791666667, 0.4420572916666667, 0.4384765625, 0.517578125, 0.4967447916666667, 0.3841145833333333, 0.349609375, 0.576171875, 0.81884765625]], [[0.75, 0.15625, 0.3125, 0.34375, 0.46875, 0.1875, 0.40625, 0.8125, 0.40625, 0.1875, 0.15625, 0.4375], [0.9111328125, 0.7405598958333334, 0.5748697916666666, 0.4378255208333333, 0.5068359375, 0.4973958333333333, 0.5660807291666666, 0.5364583333333334, 0.4306640625, 0.396484375, 0.607421875, 0.84228515625]], [[0.75, 0.15625, 0.3125, 0.34375, 0.5, 0.21875, 0.40625, 0.8125, 0.46875, 0.21875, 0.15625, 0.4375], [0.9423828125, 0.7919921875, 0.630859375, 0.4762369791666667, 0.5615234375, 0.533203125, 0.607421875, 0.5673828125, 0.4736328125, 0.4446614583333333, 0.650390625, 0.873046875]], [[0.75, 0.1875, 0.34375, 0.34375, 0.5, 0.21875, 0.40625, 0.90625, 0.46875, 0.25, 0.15625, 0.4375], [0.96435546875, 0.8251953125, 0.6787109375, 0.515625, 0.6178385416666666, 0.5764973958333334, 0.6435546875, 0.6044921875, 0.5159505208333334, 0.4899088541666667, 0.6809895833333334, 0.890625]], [[0.78125, 0.21875, 0.375, 0.34375, 0.5, 0.25, 0.40625, 0.90625, 0.46875, 0.25, 0.15625, 0.46875], [0.9775390625, 0.8567708333333334, 0.7190755208333334, 0.5579427083333334, 0.6585286458333334, 0.607421875, 0.6744791666666666, 0.6409505208333334, 0.5537109375, 0.5442708333333334, 0.7115885416666666, 0.90478515625]], [[0.78125, 0.21875, 0.40625, 0.34375, 0.5, 0.25, 0.40625, 0.90625, 0.5, 0.28125, 0.1875, 0.46875], [0.9814453125, 0.87890625, 0.7496744791666666, 0.5979817708333334, 0.6966145833333334, 0.646484375, 0.701171875, 0.6741536458333334, 0.5895182291666666, 0.5950520833333334, 0.7434895833333334, 0.91455078125]], [[0.8125, 0.25, 0.40625, 0.375, 0.5, 0.25, 0.40625, 0.90625, 0.5, 0.28125, 0.1875, 0.5625], [0.98388671875, 0.8958333333333334, 0.7747395833333334, 0.6341145833333334, 0.7320963541666666, 0.6819661458333334, 0.7288411458333334, 0.703125, 0.62109375, 0.6412760416666666, 0.7750651041666666, 0.9228515625]], [[0.8125, 0.25, 0.40625, 0.375, 0.53125, 0.25, 0.40625, 0.90625, 0.5, 0.3125, 0.21875, 0.5625], [0.98681640625, 0.9085286458333334, 0.7981770833333334, 0.6591796875, 0.7613932291666666, 0.7164713541666666, 0.7578125, 0.7373046875, 0.65234375, 0.6888020833333334, 0.8020833333333334, 0.93115234375]], [[0.8125, 0.28125, 0.40625, 0.375, 0.53125, 0.28125, 0.4375, 0.90625, 0.53125, 0.3125, 0.21875, 0.59375], [0.98779296875, 0.9212239583333334, 0.814453125, 0.6920572916666666, 0.7815755208333334, 0.7418619791666666, 0.7802734375, 0.7698567708333334, 0.6829427083333334, 0.732421875, 0.8258463541666666, 0.9375]], [[0.8125, 0.3125, 0.40625, 0.4375, 0.53125, 0.3125, 0.53125, 0.90625, 0.53125, 0.34375, 0.21875, 0.59375], [0.98876953125, 0.9283854166666666, 0.8317057291666666, 0.7154947916666666, 0.80078125, 0.7669270833333334, 0.7991536458333334, 0.7952473958333334, 0.7115885416666666, 0.7789713541666666, 0.8473307291666666, 0.94091796875]], [[0.8125, 0.34375, 0.40625, 0.4375, 0.53125, 0.3125, 0.53125, 0.90625, 0.53125, 0.34375, 0.25, 0.59375], [0.98974609375, 0.9381510416666666, 0.8515625, 0.73828125, 0.81640625, 0.7880859375, 0.8238932291666666, 0.8118489583333334, 0.7347005208333334, 0.8173828125, 0.8701171875, 0.9453125]], [[0.8125, 0.34375, 0.40625, 0.46875, 0.53125, 0.34375, 0.65625, 0.9375, 0.53125, 0.375, 0.28125, 0.59375], [0.990234375, 0.9453125, 0.8629557291666666, 0.76171875, 0.8291015625, 0.8092447916666666, 0.8479817708333334, 0.8271484375, 0.7568359375, 0.8499348958333334, 0.890625, 0.951171875]], [[0.8125, 0.34375, 0.40625, 0.5, 0.5625, 0.34375, 0.65625, 0.9375, 0.59375, 0.375, 0.28125, 0.59375], [0.99169921875, 0.9505208333333334, 0.8746744791666666, 0.783203125, 0.8450520833333334, 0.8284505208333334, 0.8616536458333334, 0.8447265625, 0.7819010416666666, 0.8772786458333334, 0.9069010416666666, 0.95263671875]], [[0.8125, 0.375, 0.4375, 0.5, 0.5625, 0.40625, 0.6875, 0.9375, 0.625, 0.4375, 0.28125, 0.59375], [0.9921875, 0.953125, 0.8841145833333334, 0.8072916666666666, 0.861328125, 0.8489583333333334, 0.8714192708333334, 0.8623046875, 0.8043619791666666, 0.8899739583333334, 0.9212239583333334, 0.955078125]]]
ber_isi12dB = [0.003419, 0.00348, 0.003509, 0.003439, 0.003445, 0.0035, 0.003395, 0.003364, 0.003402, 0.003442, 0.003494, 0.00343, 0.003475, 0.003489, 0.003505, 0.003533, 0.003522, 0.003534, 0.003635, 0.00355]

sparsity_isi12dB=(np.array(sparsity_isi12dB)/2).tolist()
plt.figure('isi12dB_row0', figsize=[4,12])
pruneNum = len(sparsity_isi12dB)-7
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi12dB[k])
	plt.bar(range(len(sparsity_isi12dB[k][0])),sparsity_isi12dB[k][0])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()


plt.figure('isi12dB_row1', figsize=[4,12])
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi12dB[k])
	plt.bar(range(len(sparsity_isi12dB[k][1])),sparsity_isi12dB[k][1])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()



sparsity_isi4dB = [[[0.03125, 0.03125, 0.0, 0.09375, 0.03125, 0.03125, 0.0, 0.03125, 0.03125, 0.4375, 0.0, 0.0], [0.05859375, 0.053059895833333336, 0.048502604166666664, 0.054361979166666664, 0.07747395833333333, 0.2021484375, 0.072265625, 0.072265625, 0.078125, 0.3489583333333333, 0.087890625, 0.0390625]], [[0.0625, 0.03125, 0.03125, 0.1875, 0.0625, 0.0625, 0.0, 0.0625, 0.03125, 0.625, 0.0, 0.0625], [0.10791015625, 0.0966796875, 0.09602864583333333, 0.11881510416666667, 0.16731770833333334, 0.3795572916666667, 0.14322916666666666, 0.14420572916666666, 0.15397135416666666, 0.6256510416666666, 0.16145833333333334, 0.0693359375]], [[0.09375, 0.03125, 0.03125, 0.25, 0.125, 0.0625, 0.0, 0.0625, 0.03125, 0.65625, 0.0, 0.0625], [0.16259765625, 0.16471354166666666, 0.1513671875, 0.17643229166666666, 0.2584635416666667, 0.5029296875, 0.20084635416666666, 0.21451822916666666, 0.23860677083333334, 0.7757161458333334, 0.2757161458333333, 0.107421875]], [[0.1875, 0.03125, 0.03125, 0.25, 0.125, 0.0625, 0.0, 0.0625, 0.03125, 0.75, 0.03125, 0.09375], [0.23681640625, 0.224609375, 0.21028645833333334, 0.2451171875, 0.3284505208333333, 0.6012369791666666, 0.2522786458333333, 0.2913411458333333, 0.3115234375, 0.8818359375, 0.3603515625, 0.15869140625]], [[0.1875, 0.03125, 0.03125, 0.25, 0.125, 0.125, 0.0, 0.0625, 0.0625, 0.84375, 0.0625, 0.125], [0.3203125, 0.2884114583333333, 0.2662760416666667, 0.314453125, 0.4069010416666667, 0.6754557291666666, 0.3017578125, 0.3551432291666667, 0.3785807291666667, 0.9309895833333334, 0.4404296875, 0.20556640625]], [[0.1875, 0.03125, 0.0625, 0.25, 0.125, 0.125, 0.0, 0.09375, 0.0625, 0.90625, 0.0625, 0.125], [0.39306640625, 0.34375, 0.3128255208333333, 0.3811848958333333, 0.4811197916666667, 0.7233072916666666, 0.3518880208333333, 0.4231770833333333, 0.4348958333333333, 0.9593098958333334, 0.5185546875, 0.2734375]], [[0.1875, 0.03125, 0.0625, 0.25, 0.125, 0.125, 0.0, 0.09375, 0.09375, 0.96875, 0.0625, 0.15625], [0.44287109375, 0.3932291666666667, 0.3606770833333333, 0.4378255208333333, 0.5413411458333334, 0.7679036458333334, 0.3977864583333333, 0.4765625, 0.494140625, 0.98046875, 0.5904947916666666, 0.35009765625]], [[0.1875, 0.03125, 0.0625, 0.25, 0.125, 0.125, 0.0, 0.09375, 0.09375, 0.96875, 0.09375, 0.15625], [0.49755859375, 0.439453125, 0.400390625, 0.4889322916666667, 0.5966796875, 0.8053385416666666, 0.4404296875, 0.5263671875, 0.5403645833333334, 0.9886067708333334, 0.6617838541666666, 0.4287109375]], [[0.21875, 0.03125, 0.0625, 0.25, 0.125, 0.125, 0.0, 0.09375, 0.09375, 0.96875, 0.09375, 0.15625], [0.54833984375, 0.4791666666666667, 0.4365234375, 0.5458984375, 0.6448567708333334, 0.8177083333333334, 0.4876302083333333, 0.5745442708333334, 0.5885416666666666, 0.9944661458333334, 0.7229817708333334, 0.50146484375]], [[0.28125, 0.03125, 0.0625, 0.25, 0.125, 0.125, 0.0, 0.09375, 0.09375, 0.96875, 0.15625, 0.15625], [0.6328125, 0.5231119791666666, 0.4765625, 0.5979817708333334, 0.681640625, 0.8323567708333334, 0.5133463541666666, 0.6158854166666666, 0.6259765625, 0.9954427083333334, 0.771484375, 0.56982421875]], [[0.34375, 0.03125, 0.09375, 0.28125, 0.125, 0.125, 0.0, 0.09375, 0.09375, 0.96875, 0.15625, 0.15625], [0.68408203125, 0.55859375, 0.5208333333333334, 0.6363932291666666, 0.7115885416666666, 0.8424479166666666, 0.5550130208333334, 0.6435546875, 0.6676432291666666, 0.9970703125, 0.8154296875, 0.6416015625]], [[0.34375, 0.03125, 0.09375, 0.28125, 0.1875, 0.125, 0.0, 0.09375, 0.09375, 0.96875, 0.15625, 0.1875], [0.71630859375, 0.595703125, 0.5546875, 0.6669921875, 0.7470703125, 0.8567708333333334, 0.5885416666666666, 0.6735026041666666, 0.7014973958333334, 0.9970703125, 0.8557942708333334, 0.7158203125]], [[0.375, 0.03125, 0.09375, 0.28125, 0.1875, 0.125, 0.0, 0.09375, 0.09375, 0.96875, 0.15625, 0.1875], [0.74072265625, 0.6399739583333334, 0.6009114583333334, 0.7008463541666666, 0.7698567708333334, 0.8678385416666666, 0.6217447916666666, 0.7008463541666666, 0.7223307291666666, 0.9970703125, 0.8873697916666666, 0.7744140625]], [[0.40625, 0.03125, 0.09375, 0.34375, 0.1875, 0.15625, 0.0, 0.09375, 0.09375, 0.96875, 0.1875, 0.25], [0.76220703125, 0.6708984375, 0.638671875, 0.7307942708333334, 0.7919921875, 0.8776041666666666, 0.6552734375, 0.7190755208333334, 0.75390625, 0.9970703125, 0.9137369791666666, 0.830078125]], [[0.40625, 0.03125, 0.09375, 0.34375, 0.1875, 0.1875, 0.0, 0.09375, 0.09375, 0.96875, 0.1875, 0.28125], [0.78466796875, 0.6927083333333334, 0.6653645833333334, 0.7552083333333334, 0.8125, 0.8883463541666666, 0.6927083333333334, 0.7431640625, 0.7828776041666666, 0.9970703125, 0.9342447916666666, 0.876953125]], [[0.40625, 0.03125, 0.09375, 0.40625, 0.1875, 0.1875, 0.03125, 0.09375, 0.09375, 0.96875, 0.21875, 0.28125], [0.806640625, 0.712890625, 0.6940104166666666, 0.7796223958333334, 0.830078125, 0.8994140625, 0.7288411458333334, 0.7669270833333334, 0.8011067708333334, 0.9970703125, 0.9475911458333334, 0.91748046875]], [[0.46875, 0.0625, 0.125, 0.4375, 0.1875, 0.25, 0.03125, 0.125, 0.09375, 0.96875, 0.25, 0.3125], [0.82373046875, 0.7366536458333334, 0.720703125, 0.8069661458333334, 0.8483072916666666, 0.9085286458333334, 0.759765625, 0.7861328125, 0.8134765625, 0.9970703125, 0.9580078125, 0.94873046875]], [[0.53125, 0.0625, 0.125, 0.4375, 0.1875, 0.3125, 0.03125, 0.125, 0.09375, 0.96875, 0.25, 0.3125], [0.83837890625, 0.7587890625, 0.7415364583333334, 0.8297526041666666, 0.86328125, 0.9182942708333334, 0.7887369791666666, 0.8092447916666666, 0.830078125, 0.9970703125, 0.9654947916666666, 0.97021484375]], [[0.53125, 0.0625, 0.15625, 0.4375, 0.1875, 0.34375, 0.0625, 0.125, 0.15625, 0.96875, 0.25, 0.375], [0.853515625, 0.7770182291666666, 0.7679036458333334, 0.8479817708333334, 0.8844401041666666, 0.9261067708333334, 0.8125, 0.8245442708333334, 0.8466796875, 0.9970703125, 0.9713541666666666, 0.982421875]], [[0.59375, 0.09375, 0.1875, 0.46875, 0.21875, 0.375, 0.0625, 0.125, 0.1875, 1.0, 0.25, 0.375], [0.865234375, 0.7991536458333334, 0.7939453125, 0.8649088541666666, 0.8935546875, 0.9342447916666666, 0.8352864583333334, 0.8375651041666666, 0.8626302083333334, 0.9970703125, 0.9768880208333334, 0.9912109375]]]


ber_isi4dB = [0.000666, 0.000703, 0.000678, 0.000685, 0.000706, 0.000678, 0.000674, 0.000662, 0.000675, 0.000686, 0.000675, 0.000688, 0.000676, 0.000689, 0.000683, 0.000675, 0.000674, 0.000679, 0.000695, 0.000688]

sparsity_isi4dB=(np.array(sparsity_isi4dB)/2).tolist()
plt.figure('isi4dB_row0', figsize=[4,12])
pruneNum = len(sparsity_isi4dB)-7
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi4dB[k])
	plt.bar(range(len(sparsity_isi4dB[k][0])),sparsity_isi4dB[k][0])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()


plt.figure('isi4dB_row1', figsize=[4,12])
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi4dB[k])
	plt.bar(range(len(sparsity_isi4dB[k][1])),sparsity_isi4dB[k][1])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()


sparsity_isi21dB = [[[0.09375, 0.0625, 0.15625, 0.09375, 0.15625, 0.125, 0.03125, 0.21875, 0.03125, 0.0625, 0.03125, 0.28125], [0.08447265625, 0.06575520833333333, 0.06640625, 0.060221354166666664, 0.08561197916666667, 0.07877604166666667, 0.0625, 0.1103515625, 0.0859375, 0.08756510416666667, 0.142578125, 0.39599609375]], [[0.125, 0.125, 0.25, 0.09375, 0.15625, 0.125, 0.03125, 0.21875, 0.03125, 0.0625, 0.0625, 0.3125], [0.17431640625, 0.15071614583333334, 0.15592447916666666, 0.1337890625, 0.19303385416666666, 0.16373697916666666, 0.1298828125, 0.17447916666666666, 0.17154947916666666, 0.17447916666666666, 0.2571614583333333, 0.5888671875]], [[0.15625, 0.1875, 0.34375, 0.09375, 0.15625, 0.125, 0.0625, 0.21875, 0.03125, 0.0625, 0.0625, 0.3125], [0.27197265625, 0.2333984375, 0.23502604166666666, 0.208984375, 0.2802734375, 0.24479166666666666, 0.2001953125, 0.2373046875, 0.2548828125, 0.265625, 0.3561197916666667, 0.6767578125]], [[0.1875, 0.1875, 0.34375, 0.09375, 0.15625, 0.125, 0.0625, 0.21875, 0.03125, 0.0625, 0.0625, 0.3125], [0.36376953125, 0.3069661458333333, 0.3167317708333333, 0.2822265625, 0.3557942708333333, 0.3199869791666667, 0.2747395833333333, 0.2965494791666667, 0.3359375, 0.33984375, 0.4293619791666667, 0.7373046875]], [[0.21875, 0.25, 0.34375, 0.09375, 0.15625, 0.125, 0.0625, 0.25, 0.03125, 0.0625, 0.0625, 0.3125], [0.4521484375, 0.3782552083333333, 0.3857421875, 0.3470052083333333, 0.4313151041666667, 0.3805338541666667, 0.337890625, 0.3531901041666667, 0.4065755208333333, 0.4016927083333333, 0.4928385416666667, 0.7900390625]], [[0.21875, 0.25, 0.34375, 0.09375, 0.15625, 0.125, 0.0625, 0.25, 0.03125, 0.09375, 0.0625, 0.3125], [0.51611328125, 0.4420572916666667, 0.4456380208333333, 0.4065755208333333, 0.4905598958333333, 0.4456380208333333, 0.3987630208333333, 0.4104817708333333, 0.4811197916666667, 0.4602864583333333, 0.5439453125, 0.830078125]], [[0.21875, 0.28125, 0.34375, 0.09375, 0.15625, 0.125, 0.0625, 0.25, 0.03125, 0.09375, 0.0625, 0.3125], [0.578125, 0.5065104166666666, 0.4983723958333333, 0.4645182291666667, 0.5361328125, 0.5081380208333334, 0.4560546875, 0.4583333333333333, 0.5413411458333334, 0.5113932291666666, 0.5888671875, 0.8525390625]], [[0.21875, 0.28125, 0.34375, 0.09375, 0.15625, 0.125, 0.0625, 0.25, 0.0625, 0.09375, 0.0625, 0.3125], [0.6298828125, 0.5533854166666666, 0.5465494791666666, 0.5152994791666666, 0.5846354166666666, 0.5621744791666666, 0.5084635416666666, 0.513671875, 0.5999348958333334, 0.5559895833333334, 0.626953125, 0.87353515625]], [[0.21875, 0.28125, 0.375, 0.09375, 0.15625, 0.125, 0.0625, 0.25, 0.0625, 0.15625, 0.0625, 0.3125], [0.66015625, 0.5986328125, 0.5924479166666666, 0.5631510416666666, 0.6295572916666666, 0.603515625, 0.5598958333333334, 0.5608723958333334, 0.6608072916666666, 0.603515625, 0.66015625, 0.8857421875]], [[0.21875, 0.28125, 0.53125, 0.09375, 0.15625, 0.125, 0.0625, 0.25, 0.0625, 0.15625, 0.0625, 0.375], [0.70947265625, 0.6350911458333334, 0.6354166666666666, 0.6116536458333334, 0.6656901041666666, 0.6419270833333334, 0.5992838541666666, 0.6083984375, 0.7034505208333334, 0.6442057291666666, 0.6917317708333334, 0.89794921875]], [[0.25, 0.28125, 0.53125, 0.09375, 0.1875, 0.125, 0.0625, 0.3125, 0.0625, 0.1875, 0.09375, 0.375], [0.7412109375, 0.669921875, 0.6647135416666666, 0.6529947916666666, 0.7014973958333334, 0.6927083333333334, 0.634765625, 0.6510416666666666, 0.7395833333333334, 0.685546875, 0.7180989583333334, 0.9072265625]], [[0.25, 0.28125, 0.53125, 0.09375, 0.1875, 0.125, 0.0625, 0.34375, 0.0625, 0.1875, 0.09375, 0.375], [0.77001953125, 0.6949869791666666, 0.6985677083333334, 0.6858723958333334, 0.7347005208333334, 0.7408854166666666, 0.6643880208333334, 0.6917317708333334, 0.775390625, 0.7197265625, 0.7447916666666666, 0.9150390625]], [[0.25, 0.3125, 0.53125, 0.09375, 0.25, 0.15625, 0.0625, 0.34375, 0.0625, 0.1875, 0.125, 0.375], [0.78955078125, 0.7161458333333334, 0.7301432291666666, 0.7177734375, 0.7705078125, 0.7809244791666666, 0.6907552083333334, 0.7307942708333334, 0.7994791666666666, 0.7490234375, 0.7669270833333334, 0.92333984375]], [[0.28125, 0.3125, 0.53125, 0.125, 0.25, 0.25, 0.09375, 0.40625, 0.15625, 0.21875, 0.15625, 0.375], [0.80224609375, 0.73828125, 0.7578125, 0.7451171875, 0.8037109375, 0.8180338541666666, 0.7164713541666666, 0.7613932291666666, 0.8229166666666666, 0.7809244791666666, 0.7838541666666666, 0.92724609375]], [[0.28125, 0.375, 0.5625, 0.21875, 0.34375, 0.25, 0.125, 0.40625, 0.15625, 0.21875, 0.15625, 0.375], [0.81787109375, 0.7613932291666666, 0.7799479166666666, 0.7698567708333334, 0.8277994791666666, 0.845703125, 0.7386067708333334, 0.798828125, 0.8430989583333334, 0.8098958333333334, 0.8001302083333334, 0.9296875]], [[0.28125, 0.375, 0.6875, 0.28125, 0.40625, 0.25, 0.125, 0.46875, 0.1875, 0.21875, 0.15625, 0.375], [0.8310546875, 0.7822265625, 0.8037109375, 0.7913411458333334, 0.8528645833333334, 0.8675130208333334, 0.7600911458333334, 0.8291015625, 0.8639322916666666, 0.8333333333333334, 0.8147786458333334, 0.935546875]], [[0.3125, 0.46875, 0.78125, 0.34375, 0.4375, 0.28125, 0.15625, 0.5, 0.21875, 0.34375, 0.15625, 0.375], [0.83984375, 0.7958984375, 0.82421875, 0.8141276041666666, 0.876953125, 0.8821614583333334, 0.7786458333333334, 0.8616536458333334, 0.8870442708333334, 0.8531901041666666, 0.8255208333333334, 0.939453125]], [[0.3125, 0.46875, 0.78125, 0.375, 0.4375, 0.3125, 0.21875, 0.5625, 0.28125, 0.34375, 0.21875, 0.375], [0.8583984375, 0.8131510416666666, 0.8404947916666666, 0.8369140625, 0.89453125, 0.8971354166666666, 0.7945963541666666, 0.8811848958333334, 0.9046223958333334, 0.8688151041666666, 0.8414713541666666, 0.9423828125]], [[0.375, 0.46875, 0.78125, 0.46875, 0.5, 0.3125, 0.28125, 0.5625, 0.28125, 0.34375, 0.25, 0.375], [0.8701171875, 0.8317057291666666, 0.8551432291666666, 0.8531901041666666, 0.9055989583333334, 0.9111328125, 0.8121744791666666, 0.8981119791666666, 0.9228515625, 0.8850911458333334, 0.8541666666666666, 0.9482421875]], [[0.375, 0.46875, 0.84375, 0.46875, 0.5, 0.46875, 0.28125, 0.625, 0.28125, 0.34375, 0.25, 0.375], [0.88525390625, 0.8473307291666666, 0.8753255208333334, 0.8727213541666666, 0.9189453125, 0.9241536458333334, 0.8255208333333334, 0.9147135416666666, 0.9290364583333334, 0.8951822916666666, 0.8655598958333334, 0.9501953125]]]



ber_isi21dB = [0.046051, 0.046524, 0.04631, 0.046633, 0.04632, 0.046426, 0.046544, 0.046731, 0.047353, 0.048316, 0.047801, 0.048423, 0.049021, 0.049857, 0.052043, 0.051904, 0.053069, 0.05327, 0.056168, 0.086396]



sparsity_isi21dB=(np.array(sparsity_isi21dB)/2).tolist()
plt.figure('isi21dB_row0', figsize=[4,12])
pruneNum = len(sparsity_isi21dB) - 7
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi21dB[k])
	plt.bar(range(len(sparsity_isi21dB[k][0])),sparsity_isi21dB[k][0])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()


plt.figure('isi21dB_row1', figsize=[4,12])
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi21dB[k])
	plt.bar(range(len(sparsity_isi21dB[k][1])),sparsity_isi21dB[k][1])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()


sparsity_isi21dB_26dBtrain =  [[[0.1875, 0.28125, 0.15625, 0.21875, 0.09375, 0.1875, 0.0, 0.34375, 0.0625, 0.0, 0.0625, 0.375], [0.11474609375, 0.09733072916666667, 0.11393229166666667, 0.1220703125, 0.08626302083333333, 0.09016927083333333, 0.051432291666666664, 0.14485677083333334, 0.07552083333333333, 0.051106770833333336, 0.0947265625, 0.23193359375]], [[0.34375, 0.3125, 0.21875, 0.21875, 0.09375, 0.1875, 0.0, 0.34375, 0.0625, 0.0, 0.0625, 0.40625], [0.23828125, 0.21451822916666666, 0.23893229166666666, 0.24609375, 0.16178385416666666, 0.177734375, 0.09342447916666667, 0.22428385416666666, 0.1298828125, 0.1005859375, 0.1904296875, 0.416015625]], [[0.34375, 0.34375, 0.21875, 0.21875, 0.09375, 0.1875, 0.0, 0.34375, 0.0625, 0.0, 0.0625, 0.40625], [0.341796875, 0.3170572916666667, 0.3483072916666667, 0.3460286458333333, 0.2506510416666667, 0.2555338541666667, 0.15397135416666666, 0.2861328125, 0.2041015625, 0.1591796875, 0.2666015625, 0.52197265625]], [[0.34375, 0.375, 0.21875, 0.21875, 0.125, 0.1875, 0.0, 0.34375, 0.0625, 0.0, 0.0625, 0.4375], [0.443359375, 0.4166666666666667, 0.4303385416666667, 0.4134114583333333, 0.3284505208333333, 0.3326822916666667, 0.21549479166666666, 0.353515625, 0.2718098958333333, 0.2216796875, 0.322265625, 0.61767578125]], [[0.34375, 0.375, 0.21875, 0.21875, 0.125, 0.1875, 0.0, 0.34375, 0.09375, 0.0, 0.0625, 0.4375], [0.53369140625, 0.4921875, 0.5013020833333334, 0.4817708333333333, 0.3961588541666667, 0.3977864583333333, 0.2819010416666667, 0.4192708333333333, 0.3356119791666667, 0.2802734375, 0.3759765625, 0.685546875]], [[0.34375, 0.40625, 0.21875, 0.21875, 0.125, 0.1875, 0.03125, 0.34375, 0.09375, 0.0, 0.0625, 0.4375], [0.5869140625, 0.5543619791666666, 0.5621744791666666, 0.5358072916666666, 0.4619140625, 0.4632161458333333, 0.3427734375, 0.4723307291666667, 0.4046223958333333, 0.3424479166666667, 0.4280598958333333, 0.7392578125]], [[0.34375, 0.40625, 0.21875, 0.21875, 0.125, 0.1875, 0.03125, 0.375, 0.09375, 0.0, 0.0625, 0.4375], [0.65380859375, 0.5983072916666666, 0.6061197916666666, 0.5846354166666666, 0.517578125, 0.5179036458333334, 0.4013671875, 0.5390625, 0.4602864583333333, 0.4124348958333333, 0.4772135416666667, 0.76904296875]], [[0.34375, 0.40625, 0.21875, 0.21875, 0.125, 0.1875, 0.03125, 0.375, 0.09375, 0.0, 0.0625, 0.4375], [0.70458984375, 0.6416015625, 0.64453125, 0.6276041666666666, 0.5732421875, 0.5732421875, 0.4453125, 0.5970052083333334, 0.5231119791666666, 0.4645182291666667, 0.5192057291666666, 0.8037109375]], [[0.375, 0.40625, 0.21875, 0.21875, 0.125, 0.21875, 0.03125, 0.375, 0.125, 0.0, 0.09375, 0.4375], [0.7392578125, 0.6800130208333334, 0.6878255208333334, 0.6705729166666666, 0.6197916666666666, 0.6184895833333334, 0.4970703125, 0.6539713541666666, 0.5774739583333334, 0.5048828125, 0.5540364583333334, 0.830078125]], [[0.375, 0.40625, 0.21875, 0.21875, 0.125, 0.21875, 0.03125, 0.375, 0.125, 0.0, 0.125, 0.4375], [0.76513671875, 0.7164713541666666, 0.7132161458333334, 0.7073567708333334, 0.6669921875, 0.6647135416666666, 0.5374348958333334, 0.7021484375, 0.6263020833333334, 0.5498046875, 0.5940755208333334, 0.84326171875]], [[0.375, 0.4375, 0.21875, 0.21875, 0.125, 0.25, 0.03125, 0.375, 0.15625, 0.03125, 0.125, 0.46875], [0.78662109375, 0.75, 0.7395833333333334, 0.7408854166666666, 0.7054036458333334, 0.7060546875, 0.5699869791666666, 0.7467447916666666, 0.6741536458333334, 0.5904947916666666, 0.62890625, 0.85888671875]], [[0.375, 0.53125, 0.28125, 0.25, 0.15625, 0.28125, 0.03125, 0.375, 0.15625, 0.03125, 0.125, 0.46875], [0.80078125, 0.7708333333333334, 0.7721354166666666, 0.7666015625, 0.7438151041666666, 0.7415364583333334, 0.6126302083333334, 0.7858072916666666, 0.7141927083333334, 0.6337890625, 0.6575520833333334, 0.8642578125]], [[0.375, 0.53125, 0.3125, 0.25, 0.21875, 0.28125, 0.03125, 0.40625, 0.1875, 0.03125, 0.125, 0.46875], [0.8193359375, 0.79296875, 0.7994791666666666, 0.8004557291666666, 0.7744140625, 0.7747395833333334, 0.6471354166666666, 0.8125, 0.7490234375, 0.6715494791666666, 0.6822916666666666, 0.8759765625]], [[0.375, 0.53125, 0.375, 0.34375, 0.21875, 0.34375, 0.03125, 0.4375, 0.1875, 0.09375, 0.125, 0.46875], [0.8369140625, 0.8157552083333334, 0.8251953125, 0.830078125, 0.8024088541666666, 0.7978515625, 0.6770833333333334, 0.8352864583333334, 0.77734375, 0.7054036458333334, 0.7086588541666666, 0.8876953125]], [[0.4375, 0.53125, 0.375, 0.34375, 0.25, 0.34375, 0.03125, 0.4375, 0.28125, 0.09375, 0.125, 0.5], [0.84912109375, 0.8330078125, 0.8460286458333334, 0.853515625, 0.8349609375, 0.8206380208333334, 0.7047526041666666, 0.8525390625, 0.8118489583333334, 0.7353515625, 0.73046875, 0.896484375]], [[0.4375, 0.625, 0.5, 0.375, 0.3125, 0.375, 0.0625, 0.4375, 0.28125, 0.125, 0.15625, 0.5], [0.86328125, 0.8505859375, 0.8714192708333334, 0.8746744791666666, 0.857421875, 0.8349609375, 0.7272135416666666, 0.8701171875, 0.8414713541666666, 0.7623697916666666, 0.75390625, 0.90380859375]], [[0.46875, 0.625, 0.53125, 0.375, 0.3125, 0.375, 0.0625, 0.4375, 0.375, 0.15625, 0.1875, 0.5], [0.87548828125, 0.8658854166666666, 0.8837890625, 0.888671875, 0.8772786458333334, 0.8544921875, 0.75390625, 0.884765625, 0.865234375, 0.7880859375, 0.7770182291666666, 0.91064453125]], [[0.46875, 0.625, 0.59375, 0.40625, 0.34375, 0.40625, 0.3125, 0.46875, 0.375, 0.1875, 0.21875, 0.5], [0.88720703125, 0.8772786458333334, 0.8984375, 0.8990885416666666, 0.890625, 0.8723958333333334, 0.7731119791666666, 0.8994140625, 0.8857421875, 0.8193359375, 0.7975260416666666, 0.91650390625]], [[0.46875, 0.6875, 0.6875, 0.4375, 0.375, 0.4375, 0.3125, 0.46875, 0.4375, 0.21875, 0.28125, 0.5], [0.8955078125, 0.8929036458333334, 0.9143880208333334, 0.9117838541666666, 0.9020182291666666, 0.8844401041666666, 0.7848307291666666, 0.9147135416666666, 0.904296875, 0.8489583333333334, 0.8147786458333334, 0.9228515625]], [[0.46875, 0.71875, 0.75, 0.4375, 0.4375, 0.46875, 0.5625, 0.59375, 0.4375, 0.25, 0.3125, 0.5], [0.9013671875, 0.900390625, 0.9235026041666666, 0.9241536458333334, 0.9104817708333334, 0.8961588541666666, 0.8017578125, 0.9248046875, 0.91796875, 0.8714192708333334, 0.8372395833333334, 0.931640625]]]


ber_isi21dB_26dBtrain = [0.000173, 0.000182, 0.000139, 0.000171, 0.000153, 0.000114, 0.000148, 0.000149, 0.000153, 0.000234, 0.000194, 0.000265, 0.000335, 0.000383, 0.000467, 0.000531, 0.002021, 0.002391, 0.002938, 0.003757] 
sparsity_isi21dB_26dBtrain=(np.array(sparsity_isi21dB)/2).tolist()
plt.figure('isi21dB_26dBtrain_row0', figsize=[4,12])
pruneNum = len(sparsity_isi21dB_26dBtrain) - 7
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi21dB_26dBtrain[k])
	plt.bar(range(len(sparsity_isi21dB_26dBtrain[k][0])),sparsity_isi21dB[k][0])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()


plt.figure('isi21dB_26dBtrain_row1', figsize=[4,12])
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi21dB_26dBtrain[k])
	plt.bar(range(len(sparsity_isi21dB_26dBtrain[k][1])),sparsity_isi21dB_26dBtrain[k][1])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()



sparsity_isi21dB_24dBtrain =  [[[0.1875, 0.15625, 0.15625, 0.125, 0.09375, 0.1875, 0.0, 0.34375, 0.0625, 0.0, 0.0625, 0.34375], [0.10888671875, 0.09147135416666667, 0.11263020833333333, 0.11979166666666667, 0.08463541666666667, 0.09537760416666667, 0.051106770833333336, 0.15201822916666666, 0.07649739583333333, 0.049153645833333336, 0.09733072916666667, 0.236328125]], [[0.34375, 0.34375, 0.21875, 0.21875, 0.09375, 0.1875, 0.0, 0.34375, 0.0625, 0.0, 0.0625, 0.40625], [0.220703125, 0.20865885416666666, 0.23600260416666666, 0.2490234375, 0.15559895833333334, 0.17838541666666666, 0.09407552083333333, 0.22884114583333334, 0.138671875, 0.09993489583333333, 0.19694010416666666, 0.4287109375]], [[0.34375, 0.375, 0.21875, 0.21875, 0.09375, 0.1875, 0.0, 0.34375, 0.0625, 0.0, 0.0625, 0.40625], [0.349609375, 0.318359375, 0.3421223958333333, 0.3538411458333333, 0.24153645833333334, 0.2506510416666667, 0.15104166666666666, 0.2877604166666667, 0.20572916666666666, 0.16048177083333334, 0.2639973958333333, 0.5302734375]], [[0.34375, 0.375, 0.21875, 0.21875, 0.125, 0.1875, 0.0, 0.34375, 0.0625, 0.0, 0.0625, 0.40625], [0.44921875, 0.4248046875, 0.4345703125, 0.421875, 0.3196614583333333, 0.3212890625, 0.21158854166666666, 0.357421875, 0.2747395833333333, 0.21809895833333334, 0.3206380208333333, 0.611328125]], [[0.34375, 0.40625, 0.21875, 0.21875, 0.125, 0.1875, 0.0, 0.34375, 0.09375, 0.0, 0.0625, 0.4375], [0.5361328125, 0.4947916666666667, 0.5078125, 0.4801432291666667, 0.3854166666666667, 0.3984375, 0.2727864583333333, 0.4251302083333333, 0.3421223958333333, 0.28125, 0.3704427083333333, 0.6787109375]], [[0.34375, 0.40625, 0.21875, 0.21875, 0.125, 0.1875, 0.03125, 0.34375, 0.09375, 0.0, 0.0625, 0.4375], [0.61572265625, 0.5530598958333334, 0.5598958333333334, 0.52734375, 0.4567057291666667, 0.4619140625, 0.3356119791666667, 0.4788411458333333, 0.4046223958333333, 0.3505859375, 0.423828125, 0.73388671875]], [[0.34375, 0.40625, 0.21875, 0.21875, 0.125, 0.1875, 0.03125, 0.375, 0.09375, 0.0, 0.0625, 0.4375], [0.67333984375, 0.60546875, 0.6018880208333334, 0.5791015625, 0.517578125, 0.5205078125, 0.4016927083333333, 0.5413411458333334, 0.4632161458333333, 0.4039713541666667, 0.4677734375, 0.767578125]], [[0.34375, 0.40625, 0.21875, 0.21875, 0.125, 0.1875, 0.03125, 0.375, 0.09375, 0.0, 0.09375, 0.4375], [0.70751953125, 0.6487630208333334, 0.6451822916666666, 0.6276041666666666, 0.5667317708333334, 0.5719401041666666, 0.4537760416666667, 0.5989583333333334, 0.5237630208333334, 0.4586588541666667, 0.5107421875, 0.79736328125]], [[0.34375, 0.4375, 0.21875, 0.21875, 0.125, 0.1875, 0.03125, 0.375, 0.125, 0.0, 0.09375, 0.4375], [0.7333984375, 0.6861979166666666, 0.673828125, 0.6650390625, 0.6181640625, 0.6145833333333334, 0.5071614583333334, 0.6572265625, 0.5875651041666666, 0.5052083333333334, 0.5546875, 0.8173828125]], [[0.34375, 0.4375, 0.21875, 0.21875, 0.125, 0.25, 0.03125, 0.375, 0.15625, 0.03125, 0.125, 0.4375], [0.75439453125, 0.716796875, 0.70703125, 0.69921875, 0.6637369791666666, 0.6604817708333334, 0.5400390625, 0.712890625, 0.6370442708333334, 0.5582682291666666, 0.5924479166666666, 0.8349609375]], [[0.34375, 0.5, 0.3125, 0.25, 0.1875, 0.25, 0.03125, 0.375, 0.15625, 0.03125, 0.125, 0.4375], [0.775390625, 0.7431640625, 0.7389322916666666, 0.7366536458333334, 0.7041015625, 0.7021484375, 0.5768229166666666, 0.7571614583333334, 0.6832682291666666, 0.5973307291666666, 0.62109375, 0.85205078125]], [[0.375, 0.5, 0.34375, 0.25, 0.1875, 0.25, 0.03125, 0.375, 0.1875, 0.09375, 0.125, 0.46875], [0.798828125, 0.7688802083333334, 0.7750651041666666, 0.7649739583333334, 0.7412109375, 0.7389322916666666, 0.6090494791666666, 0.7841796875, 0.7268880208333334, 0.638671875, 0.650390625, 0.86083984375]], [[0.375, 0.5, 0.375, 0.28125, 0.25, 0.28125, 0.03125, 0.375, 0.1875, 0.09375, 0.125, 0.46875], [0.8193359375, 0.7923177083333334, 0.8014322916666666, 0.7952473958333334, 0.7740885416666666, 0.7708333333333334, 0.6435546875, 0.8111979166666666, 0.7578125, 0.673828125, 0.6800130208333334, 0.873046875]], [[0.4375, 0.59375, 0.40625, 0.28125, 0.25, 0.34375, 0.03125, 0.4375, 0.28125, 0.125, 0.125, 0.46875], [0.830078125, 0.8157552083333334, 0.82421875, 0.8238932291666666, 0.8108723958333334, 0.8011067708333334, 0.6676432291666666, 0.8333333333333334, 0.7916666666666666, 0.70703125, 0.7024739583333334, 0.87841796875]], [[0.4375, 0.59375, 0.5, 0.375, 0.34375, 0.34375, 0.09375, 0.4375, 0.3125, 0.15625, 0.125, 0.46875], [0.84033203125, 0.8330078125, 0.8538411458333334, 0.8518880208333334, 0.8385416666666666, 0.8219401041666666, 0.6923828125, 0.8525390625, 0.8121744791666666, 0.7395833333333334, 0.7298177083333334, 0.88916015625]], [[0.4375, 0.59375, 0.53125, 0.375, 0.34375, 0.375, 0.09375, 0.4375, 0.34375, 0.15625, 0.1875, 0.46875], [0.853515625, 0.8502604166666666, 0.8743489583333334, 0.8818359375, 0.8626302083333334, 0.8391927083333334, 0.7115885416666666, 0.8694661458333334, 0.8411458333333334, 0.7682291666666666, 0.7522786458333334, 0.896484375]], [[0.46875, 0.6875, 0.65625, 0.375, 0.34375, 0.375, 0.15625, 0.46875, 0.34375, 0.15625, 0.21875, 0.5], [0.86376953125, 0.8665364583333334, 0.8981119791666666, 0.8981119791666666, 0.8798828125, 0.8544921875, 0.7301432291666666, 0.8844401041666666, 0.8645833333333334, 0.791015625, 0.7776692708333334, 0.90576171875]], [[0.5, 0.6875, 0.6875, 0.46875, 0.34375, 0.40625, 0.15625, 0.5, 0.34375, 0.15625, 0.21875, 0.5], [0.87353515625, 0.8811848958333334, 0.9176432291666666, 0.9169921875, 0.89453125, 0.8665364583333334, 0.7470703125, 0.9020182291666666, 0.8854166666666666, 0.8138020833333334, 0.7981770833333334, 0.91162109375]], [[0.5, 0.6875, 0.71875, 0.46875, 0.4375, 0.40625, 0.34375, 0.5, 0.46875, 0.25, 0.28125, 0.5], [0.8828125, 0.8942057291666666, 0.9280598958333334, 0.9235026041666666, 0.9033203125, 0.8798828125, 0.7727864583333334, 0.9114583333333334, 0.9016927083333334, 0.8424479166666666, 0.8160807291666666, 0.91943359375]], [[0.5, 0.71875, 0.78125, 0.53125, 0.4375, 0.4375, 0.65625, 0.53125, 0.46875, 0.25, 0.28125, 0.5], [0.89794921875, 0.9039713541666666, 0.9368489583333334, 0.9319661458333334, 0.9147135416666666, 0.8912760416666666, 0.7913411458333334, 0.9248046875, 0.9127604166666666, 0.8668619791666666, 0.8323567708333334, 0.927734375]]]


ber_isi21dB_24dBtrain = [0.001741, 0.001546, 0.001725, 0.001717, 0.001572, 0.001731, 0.001668, 0.001674, 0.001663, 0.001834, 0.001979, 0.002013, 0.001995, 0.002126, 0.002434, 0.002615, 0.003273, 0.007142, 0.009563, 0.010606]

sparsity_isi21dB_24dBtrain=(np.array(sparsity_isi21dB)/2).tolist()
plt.figure('isi21dB_24dBtrain_row0', figsize=[4,12])
pruneNum = len(sparsity_isi21dB_24dBtrain) - 7
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi21dB_24dBtrain[k])
	plt.bar(range(len(sparsity_isi21dB_24dBtrain[k][0])),sparsity_isi21dB[k][0])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()


plt.figure('isi21dB_24dBtrain_row1', figsize=[4,12])
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi21dB_24dBtrain[k])
	plt.bar(range(len(sparsity_isi21dB_24dBtrain[k][1])),sparsity_isi21dB_24dBtrain[k][1])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()

sparsity_isi21dB_22dBtrain =  [[[0.1875, 0.25, 0.15625, 0.15625, 0.15625, 0.15625, 0.03125, 0.3125, 0.15625, 0.03125, 0.0, 0.125], [0.0888671875, 0.09895833333333333, 0.08658854166666667, 0.1064453125, 0.10123697916666667, 0.10904947916666667, 0.061197916666666664, 0.15494791666666666, 0.10579427083333333, 0.048502604166666664, 0.1201171875, 0.171875]], [[0.1875, 0.25, 0.15625, 0.15625, 0.15625, 0.15625, 0.03125, 0.3125, 0.15625, 0.03125, 0.0, 0.125], [0.21630859375, 0.21126302083333334, 0.18359375, 0.20865885416666666, 0.18782552083333334, 0.193359375, 0.138671875, 0.23600260416666666, 0.18880208333333334, 0.10807291666666667, 0.21126302083333334, 0.31640625]], [[0.1875, 0.25, 0.15625, 0.15625, 0.15625, 0.15625, 0.03125, 0.3125, 0.15625, 0.03125, 0.0, 0.125], [0.3193359375, 0.3082682291666667, 0.2652994791666667, 0.2978515625, 0.2685546875, 0.27734375, 0.20963541666666666, 0.3193359375, 0.275390625, 0.1728515625, 0.2721354166666667, 0.41796875]], [[0.1875, 0.25, 0.15625, 0.15625, 0.1875, 0.15625, 0.03125, 0.3125, 0.15625, 0.03125, 0.0, 0.125], [0.40625, 0.3981119791666667, 0.3434244791666667, 0.373046875, 0.3509114583333333, 0.3522135416666667, 0.2799479166666667, 0.3883463541666667, 0.3548177083333333, 0.23502604166666666, 0.32421875, 0.49462890625]], [[0.1875, 0.25, 0.15625, 0.15625, 0.1875, 0.15625, 0.03125, 0.3125, 0.15625, 0.03125, 0.0, 0.125], [0.4716796875, 0.470703125, 0.4095052083333333, 0.4375, 0.4173177083333333, 0.431640625, 0.3440755208333333, 0.4576822916666667, 0.4296875, 0.2942708333333333, 0.384765625, 0.544921875]], [[0.1875, 0.25, 0.15625, 0.15625, 0.1875, 0.15625, 0.03125, 0.34375, 0.15625, 0.03125, 0.0, 0.25], [0.52734375, 0.541015625, 0.4674479166666667, 0.5078125, 0.4833984375, 0.4905598958333333, 0.4000651041666667, 0.5146484375, 0.5006510416666666, 0.3450520833333333, 0.435546875, 0.59130859375]], [[0.1875, 0.25, 0.15625, 0.15625, 0.1875, 0.15625, 0.03125, 0.40625, 0.15625, 0.03125, 0.0, 0.28125], [0.57177734375, 0.5966796875, 0.5139973958333334, 0.56640625, 0.5491536458333334, 0.5465494791666666, 0.4544270833333333, 0.5732421875, 0.5625, 0.3968098958333333, 0.48046875, 0.6328125]], [[0.21875, 0.28125, 0.15625, 0.1875, 0.25, 0.15625, 0.03125, 0.40625, 0.15625, 0.03125, 0.0, 0.3125], [0.61474609375, 0.6373697916666666, 0.5511067708333334, 0.615234375, 0.60546875, 0.6012369791666666, 0.5029296875, 0.6341145833333334, 0.6168619791666666, 0.4488932291666667, 0.5208333333333334, 0.67041015625]], [[0.25, 0.28125, 0.1875, 0.1875, 0.25, 0.15625, 0.03125, 0.40625, 0.15625, 0.03125, 0.0, 0.34375], [0.65234375, 0.671875, 0.5953776041666666, 0.6539713541666666, 0.654296875, 0.63671875, 0.5452473958333334, 0.6878255208333334, 0.6774088541666666, 0.5048828125, 0.55859375, 0.6982421875]], [[0.25, 0.28125, 0.1875, 0.21875, 0.25, 0.21875, 0.0625, 0.40625, 0.15625, 0.03125, 0.0, 0.375], [0.67724609375, 0.703125, 0.6295572916666666, 0.6953125, 0.6888020833333334, 0.6780598958333334, 0.5930989583333334, 0.736328125, 0.7236328125, 0.5524088541666666, 0.5970052083333334, 0.72705078125]], [[0.28125, 0.28125, 0.21875, 0.21875, 0.3125, 0.21875, 0.09375, 0.46875, 0.1875, 0.03125, 0.0, 0.375], [0.703125, 0.7291666666666666, 0.6627604166666666, 0.7291666666666666, 0.7259114583333334, 0.7145182291666666, 0.6282552083333334, 0.7701822916666666, 0.7737630208333334, 0.5999348958333334, 0.6259765625, 0.751953125]], [[0.28125, 0.28125, 0.25, 0.21875, 0.3125, 0.25, 0.09375, 0.5, 0.1875, 0.03125, 0.0, 0.375], [0.72607421875, 0.7503255208333334, 0.7037760416666666, 0.7669270833333334, 0.7620442708333334, 0.7483723958333334, 0.6559244791666666, 0.8014322916666666, 0.8050130208333334, 0.6412760416666666, 0.6555989583333334, 0.77001953125]], [[0.3125, 0.28125, 0.25, 0.25, 0.3125, 0.25, 0.1875, 0.53125, 0.28125, 0.03125, 0.0, 0.375], [0.74853515625, 0.7760416666666666, 0.7337239583333334, 0.8001302083333334, 0.7939453125, 0.775390625, 0.6774088541666666, 0.8271484375, 0.8359375, 0.6848958333333334, 0.6858723958333334, 0.78564453125]], [[0.375, 0.3125, 0.3125, 0.25, 0.3125, 0.25, 0.1875, 0.5625, 0.3125, 0.03125, 0.0, 0.375], [0.7666015625, 0.7958984375, 0.7672526041666666, 0.8313802083333334, 0.8154296875, 0.7972005208333334, 0.6979166666666666, 0.8548177083333334, 0.8590494791666666, 0.7275390625, 0.7115885416666666, 0.802734375]], [[0.40625, 0.3125, 0.3125, 0.34375, 0.40625, 0.3125, 0.1875, 0.59375, 0.34375, 0.03125, 0.0625, 0.375], [0.7841796875, 0.8177083333333334, 0.796875, 0.8548177083333334, 0.8352864583333334, 0.8157552083333334, 0.7141927083333334, 0.8723958333333334, 0.8821614583333334, 0.7662760416666666, 0.7392578125, 0.81640625]], [[0.40625, 0.34375, 0.34375, 0.34375, 0.4375, 0.3125, 0.25, 0.59375, 0.375, 0.0625, 0.09375, 0.375], [0.80859375, 0.8388671875, 0.8258463541666666, 0.8753255208333334, 0.857421875, 0.8291015625, 0.732421875, 0.8863932291666666, 0.9007161458333334, 0.7975260416666666, 0.7613932291666666, 0.8330078125]], [[0.4375, 0.375, 0.4375, 0.40625, 0.46875, 0.375, 0.25, 0.65625, 0.40625, 0.125, 0.125, 0.375], [0.822265625, 0.8570963541666666, 0.8561197916666666, 0.8916015625, 0.8733723958333334, 0.8440755208333334, 0.7529296875, 0.8990885416666666, 0.9163411458333334, 0.8170572916666666, 0.7900390625, 0.84814453125]], [[0.4375, 0.375, 0.5, 0.53125, 0.5, 0.46875, 0.3125, 0.6875, 0.40625, 0.125, 0.125, 0.375], [0.83447265625, 0.87109375, 0.8763020833333334, 0.9065755208333334, 0.8883463541666666, 0.8580729166666666, 0.7692057291666666, 0.9049479166666666, 0.9293619791666666, 0.8391927083333334, 0.8170572916666666, 0.869140625]], [[0.5, 0.46875, 0.5, 0.53125, 0.59375, 0.59375, 0.46875, 0.6875, 0.5, 0.21875, 0.125, 0.40625], [0.84912109375, 0.8893229166666666, 0.8922526041666666, 0.9153645833333334, 0.8971354166666666, 0.87109375, 0.7880859375, 0.9134114583333334, 0.9430338541666666, 0.8616536458333334, 0.833984375, 0.88330078125]], [[0.5625, 0.625, 0.65625, 0.53125, 0.65625, 0.8125, 0.46875, 0.6875, 0.53125, 0.375, 0.125, 0.40625], [0.85693359375, 0.9007161458333334, 0.9039713541666666, 0.923828125, 0.9052734375, 0.8854166666666666, 0.8014322916666666, 0.921875, 0.951171875, 0.8873697916666666, 0.8531901041666666, 0.8984375]]]


ber_isi21dB_22dBtrain = [0.011101, 0.011112, 0.010971, 0.010802, 0.010878, 0.011305, 0.011131, 0.011391, 0.011609, 0.012064, 0.012444, 0.01278, 0.013404, 0.01398, 0.014126, 0.014885, 0.015518, 0.016576, 0.020082, 0.021386]


sparsity_isi21dB_22dBtrain=(np.array(sparsity_isi21dB)/2).tolist()
plt.figure('isi21dB_22dBtrain_row0', figsize=[4,12])
pruneNum = len(sparsity_isi21dB_22dBtrain)- 7
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi21dB_22dBtrain[k])
	plt.bar(range(len(sparsity_isi21dB_22dBtrain[k][0])),sparsity_isi21dB[k][0])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()


plt.figure('isi21dB_22dBtrain_row1', figsize=[4,12])
for k in range(pruneNum):
	plt.subplot(pruneNum,1,k+1)
	plt.title("ber:%e "%ber_isi21dB_22dBtrain[k])
	plt.bar(range(len(sparsity_isi21dB_22dBtrain[k][1])),sparsity_isi21dB_22dBtrain[k][1])
	plt.ylim([0,1.0])
	plt.grid(True)
plt.tight_layout()




plt.show()
